import os, torch
from torch_geometric.loader import DataLoader
from torch_geometric.datasets import TUDataset

def get_mutag_loaders(batch_size=60, seed=42):
    root = os.path.join(os.path.abspath(''), 'data', 'MUTAG')
    os.makedirs(root, exist_ok=True)
    dataset = TUDataset(root, name='MUTAG').shuffle()
    n_train, n_val = int(0.8*len(dataset)), int(0.1*len(dataset))
    n_test = len(dataset) - (n_train + n_val)

    train_set, val_set, test_set = torch.utils.data.random_split(
        dataset, [n_train, n_val, n_test],
        generator=torch.Generator().manual_seed(seed)
    )
    return (
        DataLoader(train_set, batch_size=batch_size, shuffle=True),
        DataLoader(val_set, batch_size=batch_size, shuffle=False),
        DataLoader(test_set, batch_size=batch_size, shuffle=False),
        dataset
    )

